<?php
$id=$_GET["id"];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Details</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
	<!-- CSS -->


<link rel="stylesheet" type="text/css" href="vendors/styles/core.css">
	<link rel="stylesheet" type="text/css" href="vendors/styles/icon-font.min.css">
	<link rel="stylesheet" type="text/css" href="src/plugins/datatables/css/dataTables.bootstrap4.min.css">
	<link rel="stylesheet" type="text/css" href="src/plugins/datatables/css/responsive.bootstrap4.min.css">
	
		<link rel="stylesheet" type="text/css" href="vendors/styles/style.css">  

    <style>
        body {
            background-color:white;
            font-family: Arial, sans-serif;
        }
        .container {
            background: #fff;
            position: fixed;
            padding: 10px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
            margin-top: 0;
            margin-left: 0;
            margin-right: 0;
        }
        .header1 {
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 48px;
        }
        .header1 .icons i {
            font-size: 20px;
            cursor: pointer;
        }
        
    .header1 div span {
        font-size: 18px;
        color: #000;
        font-weight: 500;
    }


    .red-box  {
        padding: 80px 15px 0px 15px;
    }
    .red-box h2 {
        font-size: 20px;
        font-weight: bold;
        color: #EF000E;
    }

    .red-box h2 .span-text-p {
        font-size: 16px;
        font-weight: 400;
        color: #000;
    }

    .red-box-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
        background-color: #FEF2F5;
        padding: 20px;
        border-radius: 10px;
    }

    .container-receive {
            /* background: #fff; */
            padding: 15px;
            /* width: 320px; */
            border-radius: 10px;
            /* box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1); */
        }
        .header-receive {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 16px;
            font-weight: 400;
        }
        .header-receive a {
            text-decoration: none;
            color: #253ED6;
            font-weight: 400;
            display: flex;
            font-size: 16px;
            align-items: center;
        }
        .header-receive i {
            margin-right: 5px;
        }
        .transaction-card {
            background: #fff;
            border-radius: 10px;
            border: 1px solid #ddd;
            padding: 15px;
            margin-top: 10px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        .transaction-top {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 16px;
            font-weight: 400;
        }
        .amount {
            color: red;
            font-weight: 400;
        }
        .divider {
            border-top: 1px solid #ddd;
            margin: 10px 0;
        }
        .transaction-bottom {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 14px;
        }
        .status {
            display: flex;
            align-items: center;
            font-weight: 400;
            color: green;
        }
        .status i {
            background: green;
            color: white;
            border-radius: 50%;
            padding: 3px;
            margin-right: 5px;
            font-size: 10px;
        }
        .btn-group1 {
            display: flex;
            position: fixed;
            bottom: 0;
            right: 0;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 400;
            padding: 20px;
            width: fit-content;
            justify-content: space-between; /* Ensures spacing between buttons */
        }

.btn-group button {
    flex: 1; /* Makes both buttons take equal space */
    margin: 0 10px; /* Adds gap between buttons */
    display: flex
;
    justify-content: center;
    align-items: center;
}

.btn-group button img {
    width: 37px;
    height: 37px;
}


.address-section {
            padding: 15px 15px 0px 15px;
        }
        .address-card {
            border-radius: 10px;
            padding: 20px;
            border: 1px solid #D9D9D9;
            margin-top: 15px;
            display: flex;
            /* align-items: center; */
        }
        .address-card i {
            color: blue;
            font-size: 22px;
        width: 40px;
        height: 40px;
        /* display: flex;
        align-items:center;
        justify-content: center; */
        /* margin-top: -45px; */
        }
        .addresspart{
            padding-top: 65px;
        }
   
    .address-text {
        display: flex;
        flex-direction: column;
        font-size: 16px;
        font-weight: 500;
        line-height: 1.5;
    }


    .btn-group1 button {
        font-size: 18px;
        font-weight: 500;
    }


@media (max-width: 480px) {
    body, h1, h2, h3, h4, h5, h6, .h4, .h5, .page-header h4 {
		font-family: "Noto Sans Devanagari", serif !important;
		font-weight: normal ;
	}
}
.modal-bottom .modal-dialog {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    margin: auto;
}


.modal-content{ 
    margin-top: 75%;
    margin-bottom: 0;
    margin-left: -9px;
    margin-right: 0;
    width: 105%;
}
label {
        display: inline-block;
        margin-bottom: 0.5rem;
        font-size: 13px;
        position: relative;
        background: #fff;
        top: 18px;
        left: 20px;
        padding: 0px 5px;
        color: grey;
        z-index: 1;
    }
    </style>

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Aldrich&family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Noto+Sans+Devanagari:wght@100..900&family=Noto+Sans:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

</head>
<body>

    <div class="container">
        <!-- Header1 Section -->
        <div class="header1">
            <div class="d-flex">
                <a href="editcust.php?id=<?php echo $id;?>"><i class="icon-copy ti-close"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;<span>Manage Addresses</span>
            </div>
        </div>
    </div>


    <div class="addresspart">

        <!-- <div class="address-section">
             <h6>Billing Address</h6> 
            <div class="address-card">
                <i class="fas fa-map-marker-alt text-primary bg-light"></i>
                <div class="address-text">
                    <h6>ANBALAGAN</h6>
                    <div style="color: #565656;">9789126553</div>
                    <div style="color: #565656;">Karumandapam, Trichy, Tamil Nadu - 620012</div>
                </div>
                <div>
                    <div class="dropdown" style="float:right;">
                        <a class="btn btn-link font-12 p-0 line-height-1 no-arrow dropdown-toggle" href="#" role="button" data-toggle="dropdown">
                            <i class="icon-copy fa fa-ellipsis-v" style="color: #000;"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list1" style="min-width: fit-content; position: absolute; transform: translate3d(-117px, -197px, 0px) !important; top: 0px; left: 0px; will-change: transform;">
                            <a class="dropdown-item ordDrop" href="" style="font-size: 12px;font-weight:500;">Edit Address</a>
                            <a class="dropdown-item ordDrop" href="" style="font-size: 12px;font-weight:500;">Make as Billing Address</a>
                            <a class="dropdown-item ordDrop" href="" style="font-size: 12px;font-weight:500;">Make as shipping Address</a>
                            <a class="dropdown-item ordDrop" href="" style="font-size: 12px;font-weight:500;">Delete Address</a>
                        </div>
                    </div>
                </div>
            </div>
        </div> -->
        <div id="addressContainer"></div>
       
    </div>

    <!-- Button to Open Modal -->
<div class="btn-group1">
    <button class="btn btn-primary add-category" id="openPage3">
        <i class="fa fa-plus"></i>&nbsp;&nbsp; Add Address
    </button>
</div>

<!-- Modal -->
<div id="addressModal" class="modal fade" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-bottom">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Address</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form>
                    <label>Customer Name</label>
                    <input type="text" class="form-control" id="customerName">
                    <input type="hidden" calss="form-control" id="customerid" value="<?php echo $id?>">
                    <input type="hidden" class="form-control" id="addressid">

                    <label>Phone Number</label>
                    <input type="text" class="form-control" id="phoneNumber">

                    <label>Address</label>
                    <input type="text" class="form-control" id="address">

                    <div class="d-flex gap-2">
                        <div class="w-50">
                            <label>Pincode</label>
                            <input type="text" class="form-control" id="pincode">
                        </div>
                        <div class="w-50">
                            <label>City</label>
                            <input type="text" class="form-control" id="city">
                        </div>
                    </div>

                    <label>State</label>
                    <input type="text" class="form-control" id="state">
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary w-100" id="addaddress">Save</button>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 80%; max-width: 300px; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.3); z-index: 1000; height:25%;">
    <p>Are you sure you want to delete this address?</p>
    <button id="confirmDelete" style="background: red; color: white; padding: 10px; border: none; width: 100%; margin-top: 10px;">Yes</button>
    <button id="cancelDelete" style="background: grey; color: white; padding: 10px; border: none; width: 100%; margin-top: 10px;">No</button>
</div>

<!-- Overlay -->
<div id="overlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 999;"></div>



	
	<script src="vendors/scripts/core.js"></script>
	<script src="vendors/scripts/script.min.js"></script>
	<script src="vendors/scripts/process.js"></script>
	<script src="vendors/scripts/layout-settings.js"></script>
	<script src="src/plugins/datatables/js/jquery.dataTables.min.js"></script>
	<script src="src/plugins/datatables/js/dataTables.bootstrap4.min.js"></script>
	<script src="src/plugins/datatables/js/dataTables.responsive.min.js"></script>
	<script src="src/plugins/datatables/js/responsive.bootstrap4.min.js"></script>
	<!-- buttons for Export datatable -->
	<script src="src/plugins/datatables/js/dataTables.buttons.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.bootstrap4.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.print.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.html5.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.flash.min.js"></script>
	<script src="src/plugins/datatables/js/pdfmake.min.js"></script>
	<script src="src/plugins/datatables/js/vfs_fonts.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    document.getElementById('openPage3').addEventListener('click', function() {
    var myModal = new bootstrap.Modal(document.getElementById('addressModal'));
    myModal.show();
});

</script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
    document.getElementById("addaddress").addEventListener("click", function (e) {
        e.preventDefault(); // Prevent default button behavior

        // Get input values
        let address_id = document.getElementById("addressid").value.trim();
        let customerid = document.getElementById("customerid").value.trim();
        let customername = document.getElementById("customerName").value.trim();
        let phonenumber = document.getElementById("phoneNumber").value.trim();
        let address = document.getElementById("address").value.trim();
        let pincode = document.getElementById("pincode").value.trim();
        let city = document.getElementById("city").value.trim();
        let state = document.getElementById("state").value.trim();

        // Validate required fields
        if (!customername || !phonenumber || !address || !pincode || !city || !state) {
            alert("Please fill all fields.");
            return;
        }

        // Create data object
        let data = {
            addressid :address_id,
            customerid: customerid,
            customername: customername,
            phonenumber: phonenumber,
            address: address,
            city: city,
            state: state,
            pincode: pincode
        };

        // Send data to API
        fetch("http://localhost/hapi%20commers/api/addaddress-api.php", {
            method: "POST",
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify(data)
        })
        .then(response => response.json())
        .then(result => {
            if (result.status === "success") {
               // alert("Address added successfully!");
                location.reload(); // Reload page after success
            } else {
                alert("Error: " + result.message);
            }
        })
        .catch(error => {
            console.error("Error:", error);
            alert("Something went wrong. Please try again.");
        });
    });
});

</script>
<script>
    $(document).ready(function () {
    // Function to get query parameter from URL
    function getQueryParam(name) {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(name);
    }



    // Fetch orderid from URL
    var Id = getQueryParam('id');

    // Check if orderId is present
    if (Id) {
        $.ajax({
            url: 'http://localhost/hapi%20commers/api/getaddress-api.php',
            method: 'GET',
            data: { id: Id },
            success: function (response) {
                    console.log('Full Response:', response);
                    
                    var data;
                    try {
                        data = typeof response === 'string' ? JSON.parse(response) : response;
                    } catch (error) {
                        console.error('JSON Parsing Error:', error);
                        return;
                    }

                    console.log('Parsed Data:', data);

                    if (data && data.address && data.address.length > 0) {
                        console.log('Updating values...');
                        
                        $('#addressContainer').empty(); // Clear existing addresses

                        data.address.forEach(function (address) {
                            let addressHtml = `
                                <div class="address-section">
                                    <div class="address-card">
                                        <i class="fas fa-map-marker-alt text-primary bg-light"></i>
                                        <div class="address-text">
                                            <h6>${address.customername}</h6>
                                            <div style="color: #565656;">${address.phonenumber}</div>
                                            <div style="color: #565656;">${address.address}, ${address.city}, ${address.state} - ${address.pincode}</div>
                                        </div>
                                        <div>
                                            <div class="dropdown" style="float:right;">
                                                <a class="btn btn-link font-12 p-0 line-height-1 no-arrow dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                                    <i class="icon-copy fa fa-ellipsis-v" style="color: #000;"></i>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-right">
                                                    <a class="dropdown-item ordDrop edit-address" href="#" data-id="${address.addressid}">Edit Address</a>
                                                    <a class="dropdown-item ordDrop makeasbilling" href="#" data-addressid="${address.addressid}" data-customerid="${address.customerid}">Make as Billing Address</a>
                                                    <a class="dropdown-item ordDrop makeasshipping" href="#" data-addressid="${address.addressid}" data-customerid="${address.customerid}">Make as Shipping Address</a>
                                                    <a class="dropdown-item ordDrop" id="deleteadddress" href="#" data-id="${address.addressid}">Delete Address</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;
                            $('#addressContainer').append(addressHtml);
                        });

                    } else {
                        console.warn('No valid data received.');
                    }
                },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error('AJAX error:', textStatus, errorThrown);
            }
        });
    }
});



</script>

<script>
    $(document).on("click", ".edit-address", function (e) {
    e.preventDefault(); // Prevent default anchor behavior

    let addressId = $(this).data("id"); // Get address ID from data-id attribute
    if (!addressId) {
        alert("Invalid Address ID");
        return;
    }

    // Fetch data from API
    $.ajax({
        url: "http://localhost/hapi%20commers/api/fetchaddress-api.php?id=" + addressId, // Pass addressId as query parameter
        type: "GET", // Change request method to GET
        contentType: "application/json",
        success: function (response) {
            if (response.status === "success") {
                let address = response.data; // Extract address data

                // Populate modal fields
                $("#customerName").val(address.customername);
                $("#phoneNumber").val(address.phonenumber);
                $("#address").val(address.address);
                $("#pincode").val(address.pincode);
                $("#city").val(address.city);
                $("#state").val(address.state);
                $("#addressid").val(address.addressid);

                // Open the modal
                $("#addressModal").modal("show");
            } else {
                alert("Failed to fetch address: " + response.message);
            }
        },
        error: function () {
            alert("Error fetching address details.");
        }
    });
});

</script>


<script>
document.addEventListener("DOMContentLoaded", function () {
    let selectedAddressId = null;

    // Use event delegation to handle dynamically added elements
    document.addEventListener("click", function (event) {
        if (event.target && event.target.id === "deleteadddress") {
            event.preventDefault();
            selectedAddressId = event.target.getAttribute("data-id"); // Get address ID

            // Show modal
            document.getElementById("deleteModal").style.display = "block";
            document.getElementById("overlay").style.display = "block";
        }
    });

    // When "No" is clicked
    document.getElementById("cancelDelete").addEventListener("click", function () {
        document.getElementById("deleteModal").style.display = "none";
        document.getElementById("overlay").style.display = "none";
    });

    // When "Yes" is clicked
    document.getElementById("confirmDelete").addEventListener("click", function () {
        if (selectedAddressId) {
            fetch(`http://localhost/hapi%20commers/api/deleteaddress-api.php?addressid=${selectedAddressId}`, {
                method: "GET"
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === "success") {
                    location.reload(); // Refresh to update UI
                } else {
                    alert("Failed to delete address");
                }
            })
            .catch(error => console.error("Error:", error));
        }

        // Hide modal
        document.getElementById("deleteModal").style.display = "none";
        document.getElementById("overlay").style.display = "none";
    });
});
document.addEventListener("DOMContentLoaded", function () {
    // Function to send API request
    function updateAddress(url, addressId, customerId) {
        fetch(url, {
            method: "POST",
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify({
                addressid: addressId,
                customerid: customerId
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === "success") {
              //  alert("Address updated successfully!");
                location.reload(); // Refresh page to reflect changes
            } else {
                alert("Failed to update address.");
            }
        })
        .catch(error => console.error("Error:", error));
    }

    // Event delegation for billing address
    document.body.addEventListener("click", function (event) {
        if (event.target.classList.contains("makeasbilling")) {
            event.preventDefault();
            let addressid = event.target.getAttribute("data-addressid");
            let customerid = event.target.getAttribute("data-customerid");

            if (addressid && customerid) {
                updateAddress("http://localhost/hapi%20commers/api/makeasbillingaddress-api.php", addressid, customerid);
            }
        }
    });

    // Event delegation for shipping address
    document.body.addEventListener("click", function (event) {
        if (event.target.classList.contains("makeasshipping")) {
            event.preventDefault();
            let addressid = event.target.getAttribute("data-addressid");
            let customerid = event.target.getAttribute("data-customerid");

            if (addressid && customerid) {
                updateAddress("http://localhost/hapi%20commers/api/makeasshippingaddress-api.php", addressid, customerid);
            }
        }
    });
});

</script>
</body>
</html>
